@extends('admin.layouts.app')

@push('admin_css')
    <link href="{{asset('dashboard/assets/css/tags-input.min.css')}}" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Amiri&display=swap" rel="stylesheet">

    @if(App::getLocale() == 'ar')

@endif

@endpush

@if ($method == 'PUT')
    @section('title', \App\Helpers\TranslationHelper::translate('Edit CharitableWork'))
@else
    @section('title', \App\Helpers\TranslationHelper::translate('Add CharitableWork'))
@endif

@section('crumb')
    <x-bread-crumb :breadcrumbs="[
        ['text' => \App\Helpers\TranslationHelper::translate('CharitableWorks'), 'link' => route('admin.charitableWork.index')],
        ['text' => __('methods.' . getLastKeyRoute(request()->route()->getName()))],
    ]"
                   :button="['text' => \App\Helpers\TranslationHelper::translate('Go to CharitableWork'), 'link' => route('admin.charitableWork.index')]">
    </x-bread-crumb>
@endsection

@section('content')

    <!--begin::Content-->
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <!--begin::Post-->
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <!--begin::Container-->
            <div id="kt_content_container" class="container-xxl">
                <!--begin::Card-->
                <div class="card">
                    <!--begin::Card header-->
                    <div class="card-header border-0 pt-6">

                        <!--begin::Card body-->

                        <div class="card-body pt-0">
                            <!--begin::Form-->
                            <form action="{{ $action }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                @if ($method == 'PUT')
                                    @method('PUT')
                                    <input type="hidden" name="id" value="{{ $charitableWork->id }}">
                            @endif
                            <!--begin::Input group-->
                                <div class="fv-row mb-10">
                                    <div class="row">

                                       

                                                 {{-- @foreach (Config('language') as $key => $lang)
                                            <div class="col-6 mb-5">
                                                <label class="fs-5 fw-bold form-label mb-5">
                                                    {{\App\Helpers\TranslationHelper::translate('name in')}} {{__('methods.' . $lang)}}
                                                    :
                                                </label>
                                                <!--end::Label-->
                                                <!--begin::Input-->
                                                <input type="text" class="form-control form-control-solid"
                                                       value="{{ old('name.'.$key) ?? $charitableWork->getTranslation('name',$key)}}"
                                                       placeholder="{{\App\Helpers\TranslationHelper::translate('name in')}} {{__('methods.' . $lang)}}"
                                                       name="name[{{ $key}}]"/>
                                                @error('name.'.$key)
                                                <span class="text-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                                @enderror
                                            </div>
                                        @endforeach --}}

{{-- 
                      @foreach (Config('language') as $key => $lang)
    <div class="col-12 mb-5">
        <label class="fs-5 fw-bold form-label mb-5">
            {{ \App\Helpers\TranslationHelper::translate('Description in') }} {{ __('methods.' . $lang) }}
        </label>
        <textarea class="form-control form-control-solid full-editor" name="description[{{ $key }}]" rows="5" id="description{{$key}}"
                  style="height: 300px; direction: rtl;">{{ old('description.'.$key) ?? $charitableWork->getTranslation('description', $key) }}</textarea>
        @error('description.'.$key)
            <span class="text-danger" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
@endforeach

   --}}

                                   <div class="col-6  mb-5">
                                            <label
                                                class="fs-5 fw-bold form-label mb-5">{{ \App\Helpers\TranslationHelper::translate('Image') }}
                                                : <span class="text-danger">
                                                    {{ \App\Helpers\TranslationHelper::translate('Size') }} <span
                                                        dir="ltr">400 x 400</span></span></label>
                                            <input type="file" class="form-control form-control-solid" name="image"/>
                                            @error('image')
                                            <span class="text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                            @if ($charitableWork->getFirstMediaUrl('_image') != null)
                                                <img src="{{ $charitableWork->getFirstMediaUrl('_image') }}" alt="charitableWorks"
                                                     width="100px" style="border-radius: 5px">
                                            @endif
                                        </div>

                                         {{-- <div class="col-6 mb-5">
                <label class="fs-5 fw-bold form-label mb-5">
                    {{ \App\Helpers\TranslationHelper::translate('charitableWork video') }}:
                </label>

                <input type="file" class="form-control form-control-solid" name="charitableWork_video_one" accept="video/*"/>
                @error('charitableWork_video_one')
                    <span class="text-danger" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror

                @if($charitableWork->getFirstMediaUrl('charitable__workscharitableWork_video_one'))
                    <div class="mt-4">
                        <h5>{{ \App\Helpers\TranslationHelper::translate('Existing Video') }}:</h5>
                        <video width="100%" controls>
                            <source src="{{ $charitableWork->getFirstMediaUrl('charitable__workscharitableWork_video_one') }}" type="video/mp4">
                            {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
                        </video>
                    </div>
                @endif
            </div> --}}

            @foreach (config('language') as $key => $lang)
            <div class="col-6 mb-5">
                <label class="fs-5 fw-bold form-label mb-5">
                    {{ \App\Helpers\TranslationHelper::translate('charitableWork video') }} ({{ __('methods.' . $lang) }}) :
                </label>
        
                <input type="file" class="form-control form-control-solid" name="charitableWork_video_one[{{ $key }}]" accept="video/*" />
        
                @error('charitableWork_video_one.' . $key)
                    <span class="text-danger" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
        
                @php
                    $mediaKey = 'charitableWork_video_one_' . $key;  // صححت هنا
                    $videoUrl = $charitableWork->getFirstMediaUrl($mediaKey);
                @endphp
        
                @if($videoUrl)
                    <div class="mt-4">
                        <h5>{{ \App\Helpers\TranslationHelper::translate('Existing Video') }} ({{ __('methods.' . $lang) }}) :</h5>
                        <video width="100%" controls>
                            <source src="{{ $videoUrl }}" type="video/mp4">
                            {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
                        </video>
                    </div>
                @endif
            </div>
        @endforeach




        
                      @foreach (Config('language') as $key => $lang)
    <div class="col-12 mb-5">
        <label class="fs-5 fw-bold form-label mb-5">
            {{ \App\Helpers\TranslationHelper::translate('Description in') }} {{ __('methods.' . $lang) }}
        </label>
        <textarea class="form-control form-control-solid full-editor" name="description[{{ $key }}]" rows="5" id="description{{$key}}"
                  style="height: 300px; direction: rtl;">{{ old('description.'.$key) ?? $charitableWork->getTranslation('description', $key) }}</textarea>
        @error('description.'.$key)
            <span class="text-danger" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
@endforeach

  
        

            
                                    </div>
                                    <!--begin::Label-->
                                </div>
                                <!--end::Input group-->

                                <!--begin::Actions-->
                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary mb-5">
                                        <span
                                            class="indicator-label">{{ \App\Helpers\TranslationHelper::translate('Save') }}</span>
                                    </button>
                                </div>
                                <!--end::Actions-->
                            </form>
                            <!--end::Form-->
                        </div>


                        <!--end::Card body-->
                    </div>
                    <!--end::Card-->
                </div>
                <!--end::Container-->
            </div>
            <!--end::Post-->
        </div>
    </div>
    <!--end::Content-->

@endsection

@push('admin_js')
{{-- <script src="/path-to-your-js-file/custom.js"></script> --}}
    <script src="{{asset('dashboard/assets/js/tags-input.min.js')}}"></script>
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>


    <script src="https://cdn.tiny.cloud/1/YOUR_API_KEY/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>








    <script>
        $(document).ready(function() {
            $('#meta_tags').select2({
                tags: true,
                placeholder: 'Select or create options',
                allowClear: true
            });
        });
    </script>



{{-- <script>
    tinymce.init({
    selector: '#description1',
    directionality: 'rtl',
    content_css: '//fonts.googleapis.com/css?family=Tajawal',
    plugins: 'directionality',
    toolbar: 'ltr rtl',
    setup: function (editor) {
        editor.on('init', function () {
            if (document.documentElement.lang === 'ar') {
                editor.getBody().style.direction = 'rtl';
                editor.getBody().style.fontFamily = "'Tajawal', Arial, sans-serif";
            }
        });
    }
});
</script> --}}




 
@endpush

