@extends('admin.layouts.app')
@section('title', \App\Helpers\TranslationHelper::translate('Product Details'))
@section('crumb')
    <x-bread-crumb :breadcrumbs="[
        ['text'=>\App\Helpers\TranslationHelper::translate('Products'),'link'=>route('admin.product.index')],
        ['text'=> \App\Helpers\TranslationHelper::translate('Details')]
        ]" :button="[]">
    </x-bread-crumb>
@endsection
@section('content')


    {{-- <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                <div class="card">
                    <div class="card-header border-0 pt-6">
                        <div class="card-body py-4 px-0" dir="{{Config::get('app.locale') == 'en' ? 'ltr' : 'rtl'}}">
                            <div class="row px-0 mt-3">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left">
                                    <h4 class="d-inline-block  py-3">{{\App\Helpers\TranslationHelper::translate('Product Details')}}</h4>
                                </div>
                           @if (auth()->guard('admin')->user()->can('product.edit', 'admin'))
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-6  text-right">
                                        <a class="btn btn-primary text-center" style="margin-left: 25px"
                                           href="{{route('admin.product.edit', $product->id)}}">
                                            <span>{{\App\Helpers\TranslationHelper::translate('Edit')}}</span> &nbsp;
                                            <i class="fas fa-pen"></i>
                                        </a>
                                    </div>
                               @endif
                            </div>

                      <div class="row px-0 mt-3">
                                @foreach (Config('language') as $key => $lang)
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-12 m-auto text-left ">
                                        <div class="row">
                                            <div
                                                class="col-lg-3 col-md-3 col-sm-3 col-6  text-left details_item bold">
                                                {{\App\Helpers\TranslationHelper::translate('Name in')}}  {{__('methods.' . $lang)}}:
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-6  text-left details_item ">
                                                {{$product->getTranslation('name',$key)}}
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>


                                                    <div class="row px-0 mt-3">
                                @foreach (Config('language') as $key => $lang)
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-12 m-auto text-left ">
                                        <div class="row">
                                            <div
                                                class="col-lg-3 col-md-3 col-sm-3 col-6  text-left details_item bold">
                                                {{\App\Helpers\TranslationHelper::translate('Description in')}}  {{__('methods.' . $lang)}}:
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-6  text-left details_item ">
                                                {!! $product->getTranslation('description',$key) !!}
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            
                     
                            <div class="row px-0 mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12 m-auto text-left ">
                                    <div class="row">
                                        <div
                                            class="col-lg-3 col-md-3 col-sm-3 col-6  text-left details_item bold">
                                            {{\App\Helpers\TranslationHelper::translate('Image')}} :
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-6  text-left details_item ">
                                            <a href="{{ $product->getFirstMediaUrl('products') }}" target="_blank">
                                                <img src="{{ $product->getFirstMediaUrl('products') }}" class="img-fluid"
                                                     alt="test" style="width: 150px; height: 150px; object-fit: contain;">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div> --}}
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <div id="kt_content_container" class="container-xxl">
            <div class="card">
                <div class="card-header border-0 pt-6">
                    <div class="card-body py-4 px-0" dir="{{ Config::get('app.locale') == 'en' ? 'ltr' : 'rtl' }}">
                        
                        <!-- Title Section -->
                        <div class="row px-0 mt-3 align-items-center">
                            <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left">
                                <h4 class="py-3">{{ \App\Helpers\TranslationHelper::translate('Product Details') }}</h4>
                            </div>
                            @if (auth()->guard('admin')->user()->can('product.edit', 'admin'))
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-right">
                                    <a class="btn btn-primary" href="{{ route('admin.product.edit', $product->id) }}">
                                        <span>{{ \App\Helpers\TranslationHelper::translate('Edit') }}</span> &nbsp;
                                        <i class="fas fa-pen"></i>
                                    </a>
                                </div>
                            @endif
                        </div>
                        
                        <!-- Product Name Section -->
                        <div class="row px-0 mt-3">
                            @foreach (Config('language') as $key => $lang)
                                <div class="col-12 m-auto text-left">
                                    <div class="row align-items-center">
                                        <div class="col-lg-3 col-md-4 col-sm-12 text-left details_item bold">
                                            {{ \App\Helpers\TranslationHelper::translate('Name in') }} {{ __('methods.' . $lang) }}:
                                        </div>
                                        <div class="col-lg-9 col-md-8 col-sm-12 details_item">
                                            {{ $product->getTranslation('name', $key) }}
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        

                         <div class="row">
        <div class="col-lg-3 col-md-3 col-sm-3 col-6 text-left details_item bold">
            {{ \App\Helpers\TranslationHelper::translate('product category') }}
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left details_item">
            {{ $product->Productcategory->name ?? '-' }} 
        </div>
    </div>

                        <!-- Product Description Section -->
                        <div class="row px-0 mt-3">
                            @foreach (Config('language') as $key => $lang)
                                <div class="col-12 m-auto text-left">
                                    <div class="row align-items-center">
                                        <div class="col-lg-3 col-md-4 col-sm-12 text-left details_item bold">
                                            {{ \App\Helpers\TranslationHelper::translate('Description in') }} {{ __('methods.' . $lang) }}:
                                        </div>
                                        <div class="col-lg-9 col-md-8 col-sm-12 details_item">
                                            {!! $product->getTranslation('description', $key) !!}
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        
                        <!-- Product Image Section -->
                        {{-- <div class="row px-0 mt-3">
                            <div class="col-12 m-auto text-left">
                                <div class="row align-items-center">
                                    <div class="col-lg-3 col-md-4 col-sm-12 text-left details_item bold">
                                        {{ \App\Helpers\TranslationHelper::translate('Image') }}:
                                    </div>
                                    <div class="col-lg-9 col-md-8 col-sm-12 details_item">
                                        <a href="{{ $product->getFirstMediaUrl('products') }}" target="_blank">
                                            <img src="{{ $product->getFirstMediaUrl('products') }}" 
                                                 class="img-fluid" 
                                                 alt="product-image" 
                                                 style="width: 150px; height: 150px; object-fit: contain;">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div> --}}

                        <div class="row px-0 mt-3">
    <div class="col-12 m-auto text-left">
        <div class="row align-items-center">
            <div class="col-lg-3 col-md-4 col-sm-12 text-left details_item bold">
                {{ \App\Helpers\TranslationHelper::translate('Images') }}:
            </div>
            <div class="col-lg-9 col-md-8 col-sm-12 details_item">
                @foreach($product->getMedia('products') as $media)
                    <a href="{{ $media->getUrl() }}" target="_blank">
                        <img src="{{ $media->getUrl() }}" 
                             class="img-fluid" 
                             alt="product-image" 
                             style="width: 150px; height: 150px; object-fit: contain; margin-right: 10px;">
                    </a>
                @endforeach
            </div>
        </div>
    </div>
</div>


                          {{-- <div class="row px-0 mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12 m-auto text-left ">
                                    <div class="row">
                                        <div
                                            class="col-lg-3 col-md-3 col-sm-3 col-6  text-left details_item bold">
                                            {{\App\Helpers\TranslationHelper::translate('Category')}}
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-6  text-left details_item ">
                                            {{ $product->categorygallery->name ?? '-' }}
                                        </div>
                                    </div>
                                </div>
                            </div> --}}



                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@stop
@section('script')
  
@stop
