@extends('admin.layouts.app')
@section('title', \App\Helpers\TranslationHelper::translate('setting royal Crown Coin'))
@section('crumb')
    <x-bread-crumb :breadcrumbs="[
        [
            'text' => \App\Helpers\TranslationHelper::translate('setting royal Crown Coin'),
            'link' => route('admin.setting.royalCrownCoin.index'),
        ],
        ['text' => \App\Helpers\TranslationHelper::translate('Edit')],
    ]" :button="[]">
    </x-bread-crumb>
@endsection
@section('content')

    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <!--begin::Post-->
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <!--begin::Container-->
            <div id="kt_content_container" class="container-xxl">
                <!--begin::Card-->
                <div class="card">
                    <!--begin::Card header-->
                    <div class="card-header border-0 pt-6">
                        <!--begin::Card body-->
                        <div class="card-body py-4 px-0">
                            <div class="row px-0 mt-3">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left">
                                    <h4 class="d-inline-block  py-3">
                                        {{ \App\Helpers\TranslationHelper::translate('Edit royal Crown Coin') }} </h4>
                                </div>
                            </div>
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <form action="{{ route('admin.setting.royalCrownCoin.update') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')


                                <div class="row px-0 mt-3">
                                    @foreach (Config('language') as $key => $lang)
                                        <div class="col-md-6 mb-4">
                                            <div class="form-group">
                                                <label
                                                    class="bold">{{ \App\Helpers\TranslationHelper::translate('title_royalCrownCoin') }}
                                                    <span class="text-danger">*</span> {{ __('methods.' . $lang) }}</label>
                                                <input type="text" name="title_royalCrownCoin[{{ $key }}]"
                                                    class="form-control form-control-solid"
                                                    value="{{ old('title_royalCrownCoin.' . $key) ?? setting('title_royalCrownCoin', $key) }}" />
                                                @error('title_royalCrownCoin.' . $key)
                                                    <span class="text-danger" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                    @endforeach
                                </div>







                                <div class="row px-0 mt-3">
                                    @foreach (Config('language') as $key => $lang)
                                        <div class="col-12 my-5">
                                            <label class="fs-5 fw-bold form-label bold mb-2">
                                                {{ \App\Helpers\TranslationHelper::translate('description_royalCrownCoin in') }}
                                                {{ __('methods.' . $lang) }}:
                                            </label>
                                            <textarea name="description_royalCrownCoin[{{ $key }}]"
                                                class="form-control form-control-solid content_textarea full-editor"
                                                id="description_royalCrownCoin_{{ $key }}">{{ old('description_royalCrownCoin.' . $key) ?? setting('description_royalCrownCoin', $key) }}</textarea>
                                            @error('description_royalCrownCoin.' . $key)
                                                <span class="text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    @endforeach
                                </div>

                                {{-- <div class="row px-0 mt-3">
    <div class="col-md-6 mb-4">
        <div class="form-group">
            <label class="bold">{{ \App\Helpers\TranslationHelper::translate('Video One Royal Crown Coin') }} <span class="text-danger">*</span></label>
            <input type="file" name="Video_one_royalCrownCoin" accept="video/*" class="form-control form-control-solid" />
            @if (setting('Video_one_royalCrownCoin', 'en'))
                <video width="320" height="240" controls class="mt-2">
                    <source src="{{ setting('Video_one_royalCrownCoin', 'en') }}" type="video/mp4">
                    {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
                </video>
            @endif
            @error('Video_one_royalCrownCoin')
                <span class="text-danger" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
            @enderror
        </div>
    </div>
</div>

<div class="col-md-6 mb-4">
    <div class="form-group">
        <label class="bold">{{ \App\Helpers\TranslationHelper::translate('Video Two Royal Crown Coin') }} <span class="text-danger">*</span></label>
        <input type="file" name="Video_tow_royalCrownCoin" accept="video/*" class="form-control form-control-solid" />
        @if (setting('Video_tow_royalCrownCoin', 'en'))
            <video width="320" height="240" controls class="mt-2">
                <source src="{{ setting('Video_tow_royalCrownCoin', 'en') }}" type="video/mp4">
                {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
            </video>
        @endif
        @error('Video_tow_royalCrownCoin')
            <span class="text-danger" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
</div> --}}

@foreach(config('language') as $key => $lang)
    <div class="col-md-6 mb-4">
        <div class="form-group">
            <label class="bold">
                {{ \App\Helpers\TranslationHelper::translate('Video One Royal Crown Coin') }} ({{ __('methods.' . $lang) }})
            </label>
            <input type="file" name="Video_one_royalCrownCoin[{{ $key }}]" accept="video/*" class="form-control form-control-solid" />

            @php
                $videoOneSetting = \App\Models\Setting::where('option', 'Video_one_royalCrownCoin')->first();
                $videoOneMedia = $videoOneSetting?->getFirstMediaUrl("Video_one_royalCrownCoin_$key");
            @endphp

            @if ($videoOneMedia)
                <video width="320" height="240" controls class="mt-2">
                    <source src="{{ $videoOneMedia }}" type="video/mp4">
                    {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
                </video>
            @else
                <span class="text-muted">{{ \App\Helpers\TranslationHelper::translate('No video uploaded.') }}</span>
            @endif
        </div>
    </div>
@endforeach

{{-- نفس الشيء للفيديو الثاني --}}
@foreach(config('language') as $key => $lang)
    <div class="col-md-6 mb-4">
        <div class="form-group">
            <label class="bold">
                {{ \App\Helpers\TranslationHelper::translate('Video Two Royal Crown Coin') }} ({{ __('methods.' . $lang) }})
            </label>
            <input type="file" name="Video_tow_royalCrownCoin[{{ $key }}]" accept="video/*" class="form-control form-control-solid" />

            @php
                $videoTwoSetting = \App\Models\Setting::where('option', 'Video_tow_royalCrownCoin')->first();
                $videoTwoMedia = $videoTwoSetting?->getFirstMediaUrl("Video_tow_royalCrownCoin_$key");
            @endphp

            @if ($videoTwoMedia)
                <video width="320" height="240" controls class="mt-2">
                    <source src="{{ $videoTwoMedia }}" type="video/mp4">
                    {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
                </video>
            @else
                <span class="text-muted">{{ \App\Helpers\TranslationHelper::translate('No video uploaded.') }}</span>
            @endif
        </div>
    </div>
@endforeach




                                <div class="row px-0 mt-3">
                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label
                                                class="bold">{{ \App\Helpers\TranslationHelper::translate('projects_image_royalCrownCoin') }}
                                                <span class="text-danger">*</span></label>
                                            <input type="file" name="projects_image_royalCrownCoin"
                                                class="form-control form-control-solid" />
                                            @if (setting('projects_image_royalCrownCoin', 'en'))
                                                <img src="{{ setting('projects_image_royalCrownCoin', 'en') }}" width="100"
                                                    class="mt-2" />
                                            @endif
                                            @error('projects_image_royalCrownCoin')
                                                <span class="text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="mt-5" style="text-align: right">
                                    <button type="submit" class="btn btn-primary">
                                        <span class="indicator-label">Update</span>
                                    </button>
                                </div>
                            </form>
                        </div>


                    </div>

                    <!--end::Card body-->
                </div>
                <!--end::Card-->
            </div>
            <!--end::Container-->
        </div>
        <!--end::Post-->
    </div>
    <!--end::Content-->
@stop
@section('script')
    <script></script>
@stop
