@extends('admin.layouts.app')
@section('title', \App\Helpers\TranslationHelper::translate('setting royal Crown Coin'))
@section('crumb')
    <x-bread-crumb :breadcrumbs="[
        [
            'text' => \App\Helpers\TranslationHelper::translate('setting royal Crown Coin'),
            'link' => route('admin.setting.royalCrownCoin.index'),
        ],
        ['text' => \App\Helpers\TranslationHelper::translate('Details')],
    ]" :button="[]">
    </x-bread-crumb>
@endsection
@section('content')


    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <!--begin::Post-->
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <!--begin::Container-->
            <div id="kt_content_container" class="container-xxl">
                <!--begin::Card-->
                <div class="card">
                    <!--begin::Card header-->
                    <div class="card-header border-0 pt-6">
                        <!--begin::Card body-->
                        <div class="card-body py-4 px-0">
                            <div class="row px-0 mt-3">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left">
                                    <h4 class="d-inline-block  py-3">
                                        {{ \App\Helpers\TranslationHelper::translate('setting royal Crown Coin') }}</h4>
                                </div>
                                {{-- @if (auth()->guard('admin')->user()->can('home_couronne_setting.edit', 'admin')) --}}
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6  text-right">
                                    <a class="btn btn-primary text-center" style="margin-left: 25px"
                                        href="{{ route('admin.setting.royalCrownCoin.edit') }}">
                                        <span>{{ \App\Helpers\TranslationHelper::translate('Edit') }}</span> &nbsp;
                                        <i class="fas fa-pen"></i>
                                    </a>
                                </div>
                                {{-- @endif --}}
                            </div>

                            <div class="row px-0 mt-3">
                                @foreach (Config('language') as $key => $lang)
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-12 m-auto text-left ">
                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-3 col-6  text-left details_item bold">
                                                {{ \App\Helpers\TranslationHelper::translate('title_royalCrownCoin in') }}
                                                {{ __('methods.' . $lang) }}:
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-6  text-left details_item ">
                                                {{ setting('title_royalCrownCoin', $key) }}
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>


                            <div class="row px-0 mt-3">
                                @foreach (Config('language') as $key => $lang)
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-12 m-auto text-left ">
                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-sm-3 col-6  text-left details_item bold">
                                                {{ \App\Helpers\TranslationHelper::translate('description_royalCrownCoin in') }}
                                                {{ __('methods.' . $lang) }}:
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-6  text-left details_item ">
                                                {!! setting('description_royalCrownCoin', $key) !!}
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            {{-- <div class="row px-0 mt-3">
    <div class="col-lg-12 col-md-12 col-sm-12 col-12 m-auto text-left">
        <div class="row">
            <div class="col-lg-3 col-md-3 col-sm-3 col-6 text-left details_item bold">
                {{ \App\Helpers\TranslationHelper::translate('Video_one_royalCrownCoin') }} :
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left details_item">
                @if (setting('Video_one_royalCrownCoin', 'en'))
                    <video class="img-fluid" style="width: 150px; height: 150px; object-fit: contain;" controls>
                        <source src="{{ setting('Video_one_royalCrownCoin', 'en') }}" type="video/mp4">
                        {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
                    </video>
                @else
                    <span class="text-muted">{{ \App\Helpers\TranslationHelper::translate('No video uploaded.') }}</span>
                @endif
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-lg-3 col-md-3 col-sm-3 col-6 text-left details_item bold">
                {{ \App\Helpers\TranslationHelper::translate('Video_tow_royalCrownCoin') }} :
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left details_item">
                @if (setting('Video_tow_royalCrownCoin', 'en'))
                    <video class="img-fluid" style="width: 150px; height: 150px; object-fit: contain;" controls>
                        <source src="{{ setting('Video_tow_royalCrownCoin', 'en') }}" type="video/mp4">
                        {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
                    </video>
                @else
                    <span class="text-muted">{{ \App\Helpers\TranslationHelper::translate('No video uploaded.') }}</span>
                @endif
            </div>
        </div>

    </div>
</div>

 --}}

 
 @php
 $videoOneSetting = \App\Models\Setting::where('option', 'Video_one_royalCrownCoin')->first();
 $videoTwoSetting = \App\Models\Setting::where('option', 'Video_tow_royalCrownCoin')->first();
@endphp

{{-- Video One --}}
@foreach(config('language') as $key => $lang)
 <div class="row mt-3">
     <div class="col-lg-3 col-md-3 col-sm-3 col-6 text-left details_item bold">
         {{ \App\Helpers\TranslationHelper::translate('Video One Royal Crown Coin') }} ({{ __('methods.' . $lang) }})
     </div>
     <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left details_item">
         @php
             $videoOneUrl = $videoOneSetting?->getFirstMediaUrl("Video_one_royalCrownCoin_$key");
         @endphp

         @if ($videoOneUrl)
             <video class="img-fluid" style="width: 150px; height: 150px; object-fit: contain;" controls>
                 <source src="{{ $videoOneUrl }}" type="video/mp4">
                 {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
             </video>
         @else
             <span class="text-muted">{{ \App\Helpers\TranslationHelper::translate('No video uploaded.') }}</span>
         @endif
     </div>
 </div>
@endforeach

{{-- Video Two --}}
@foreach(config('language') as $key => $lang)
 <div class="row mt-3">
     <div class="col-lg-3 col-md-3 col-sm-3 col-6 text-left details_item bold">
         {{ \App\Helpers\TranslationHelper::translate('Video Two Royal Crown Coin') }} ({{ __('methods.' . $lang) }})
     </div>
     <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left details_item">
         @php
             $videoTwoUrl = $videoTwoSetting?->getFirstMediaUrl("Video_tow_royalCrownCoin_$key");
         @endphp

         @if ($videoTwoUrl)
             <video class="img-fluid" style="width: 150px; height: 150px; object-fit: contain;" controls>
                 <source src="{{ $videoTwoUrl }}" type="video/mp4">
                 {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
             </video>
         @else
             <span class="text-muted">{{ \App\Helpers\TranslationHelper::translate('No video uploaded.') }}</span>
         @endif
     </div>
 </div>
@endforeach



                            {{-- <div class="row px-0 mt-3">
    <div class="col-lg-12 col-md-12 col-sm-12 col-12 m-auto text-left ">
        <div class="row">
            <div class="col-lg-3 col-md-3 col-sm-3 col-6 text-left details_item bold">
                 {{ \App\Helpers\TranslationHelper::translate('Video One Royal Crown Coin:') }}
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left details_item">
                @if (setting('Video_one_royalCrownCoin', 'en'))
                    <video width="300" height="200" controls style="object-fit: contain;">
                        <source src="{{ setting('Video_one_royalCrownCoin', 'en') }}" type="video/mp4">
                         {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
                    </video>
                @else
                    <span class="text-muted"> {{ \App\Helpers\TranslationHelper::translate('No video uploaded.') }}</span>
                @endif
            </div>

            <div class="col-lg-3 col-md-3 col-sm-3 col-6 text-left details_item bold mt-3">
                 {{ \App\Helpers\TranslationHelper::translate('Video Two Royal Crown Coin:') }}
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left details_item mt-3">
                @if (setting('Video_tow_royalCrownCoin', 'en'))
                    <video width="300" height="200" controls style="object-fit: contain;">
                        <source src="{{ setting('Video_tow_royalCrownCoin', 'en') }}" type="video/mp4">
                         {{ \App\Helpers\TranslationHelper::translate('Your browser does not support the video tag.') }}
                    </video>
                @else
                    <span class="text-muted"> {{ \App\Helpers\TranslationHelper::translate('No video uploaded.') }}</span>
                @endif
            </div>
        </div>
    </div>
</div> --}}



                            <div class="row px-0 mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12 m-auto text-left ">
                                    <div class="row">
                                        <div class="col-lg-3 col-md-3 col-sm-3 col-6  text-left details_item bold">
                                            {{ \App\Helpers\TranslationHelper::translate('projects_image_royalCrownCoin') }} :
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-6  text-left details_item ">
                                            <img src="{{ setting('projects_image_royalCrownCoin', 'en') }}" class="img-fluid"
                                                alt="test" style="width: 150px; height: 150px; object-fit: contain;">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            

                        </div>
                    </div>
                    <!--end::Card body-->
                </div>
                <!--end::Card-->
            </div>
            <!--end::Container-->
        </div>
        <!--end::Post-->
    </div>
    <!--end::Content-->
    </div>

@stop
@section('script')
    <script></script>
@stop
