@extends('admin.layouts.app')
@section('title', \App\Helpers\TranslationHelper::translate('Terms of Use Setting'))
@section('crumb')
    <x-bread-crumb :breadcrumbs="[
        ['text'=>\App\Helpers\TranslationHelper::translate('Terms of Use Setting'),'link'=>route('admin.setting.use_terms.index')],
        ['text'=> \App\Helpers\TranslationHelper::translate('Edit')]
        ]" :button="[]">
    </x-bread-crumb>
@endsection
@section('content')


    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <!--begin::Post-->
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <!--begin::Container-->
            <div id="kt_content_container" class="container-xxl">
                <!--begin::Card-->
                <div class="card">
                    <!--begin::Card header-->
                    <div class="card-header border-0 pt-6">

                        <!--begin::Card body-->

                        <div class="card-body py-4 px-0">

                            <div class="row px-0 mt-3">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6 text-left">
                                    <h4 class="d-inline-block  py-3">{{\App\Helpers\TranslationHelper::translate('Edit Terms of Use Setting')}} </h4>
                                </div>
                            </div>
                            <form action="{{ route('admin.setting.use_terms.update') }}" method="POST"
                                  enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row px-0 mt-3">

                                    @foreach (Config('language') as $key => $lang)
                                        <div class="col-12 my-5">
                                            <label class="fs-5 fw-bold form-label bold mb-2">
                                                {{\App\Helpers\TranslationHelper::translate('Description in')}} {{__('methods.' . $lang)}}:
                                            </label>
                                            <!--end::Label-->
                                            <!--begin::Input-->
                                            <textarea name="use_terms[{{ $key}}]"
                                                      class="form-control form-control-solid content_textarea full-editor" id="{{$key}}">{{ old('use_terms.'.$key) ?? setting('use_terms',$key)}}</textarea>
                                            @error('use_terms.'.$key)
                                            <span class="text-danger" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                            @enderror
                                        </div>
                                    @endforeach
                                </div>
                                <div class="mt-5" style="text-align: right">
                                    <button type="submit" class="btn btn-primary">
                                        <span class="indicator-label">Update</span>
                                    </button>
                                </div>
                            </form>
                        </div>


                    </div>

                    <!--end::Card body-->
                </div>
                <!--end::Card-->
            </div>
            <!--end::Container-->
        </div>
        <!--end::Post-->
    </div>
    <!--end::Content-->
@stop
@section('script')
    <script>

    </script>
@stop
