@extends('front.layouts.app')

@section('content')
    <!-- ============= main ================= -->
    <main>

        <section class="section-one pt-5 position-relative">
            <div class="container">
                <div style="height: 100%" class="row align-items-center hero-mane-index">
                    <div class="col-md-6 text-center" data-aos="fade-left" data-aos-duration="1000">
                        <div class="text-hero-hero-mane-index d-flex">
                            <div class="text-main-hero-tip">

                                <div class="container">
                                    <div class="row d-flex align-items-stretch" style="--bs-gutter-x: 0.5rem;">
                                        @foreach ($projects as $index => $project)
                                            <div class="col-md-4 mb-2 d-flex">
                                                <a href="{{ route('project.show', $project->id) }}"
                                                    class="project-btn w-100">
                                                    {{ $project->name }}
                                                </a>
                                            </div>
                                            @if (($index + 1) % 3 === 0)
                                    </div>
                                    <div class="row d-flex align-items-stretch" style="--bs-gutter-x: 0.5rem;">
                                        @endif
                                        @endforeach
                                    </div>
                                </div>

                                {{-- <div class="row d-flex justify-content-center align-items-stretch"
                                    style="--bs-gutter-x: 0.5rem;">
                                    <div class="col-md-4 mb-2 d-flex justify-content-center">
                                        <a href="{{ route('charitable-Works') }}" class="project-btn w-100 text-center">
                                            <h5>{{ \App\Helpers\TranslationHelper::translate('charity') }}</h5>
                                        </a>
                                    </div>
                                </div>

                                <div class="row d-flex justify-content-center align-items-stretch"
                                    style="--bs-gutter-x: 0.5rem;">
                                    <div class="col-md-4 mb-2 d-flex justify-content-center">
                                        <a href="{{ route('royal-crown-coin') }}" class="project-btn w-100 text-center">
                                            <h5>{{ \App\Helpers\TranslationHelper::translate('Royal Crown Coin') }}</h5>
                                        </a>
                                    </div>
                                </div> --}}

                                <div class="row d-flex justify-content-center align-items-stretch" style="--bs-gutter-x: 0.5rem;">
    <div class="col-md-4 mb-2 d-flex justify-content-center">
        <a href="{{ route('charitable-Works') }}" class="project-btn w-100 text-center">
            <h5>{{ \App\Helpers\TranslationHelper::translate('charity') }}</h5>
        </a>
    </div>
    <div class="col-md-4 mb-2 d-flex justify-content-center">
        <a href="{{ route('royal-crown-coin') }}" class="project-btn w-100 text-center">
            <h5>{{ \App\Helpers\TranslationHelper::translate('Royal Crown Coin') }}</h5>
        </a>
    </div>
</div>



                                <span style="font-size: 30px; font-weight: bold; color: rgb(241, 196, 15);">
                                    {{ \App\Helpers\TranslationHelper::translate('Royal Crown Vip') }}
                                </span>
                                <h2 style="color: #fff; font-size: 18px; margin-top: 15px;">
                                    {{ \App\Helpers\TranslationHelper::translate('It is the strongest digital currency with a promising future in the crypto-currency trading market; it is expected to be among the top five digital currencies without dispute') }}
                                </h2>
                                <div class="mt-4">
                                    <div class="mt-3">
                                        <a href="{{ route('about') }}" class="btn btn-primary"
                                            style="background-color: rgb(255 255 255 / 20%); border: none; padding: 10px 20px; font-size: 18px; color:rgb(255, 255, 255)">
                                            {{ \App\Helpers\TranslationHelper::translate('About Us') }}
                                        </a>
                                        <a href="{{ route('contact-us') }}" class="btn btn-primary"
                                            style="background-color:rgb(255 255 255 / 20%); border: none; padding: 10px 20px; font-size: 18px; color:rgb(255, 255, 255)">
                                            {{ \App\Helpers\TranslationHelper::translate('Contact Us') }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <img src="{{ asset(setting('image_one_home', 'en')) }}" alt="Logo"
                            style=" width: 100%; height: 425px;">
                    </div>
                </div>
            </div>
        </section>



        <section class="section-one pt-5">
            <div class="container ">
                <div class="row align-items-center ">
                    <div class="col-md-6" data-aos="fade-up" data-aos-duration="1000">
                        <div class="text-hero">
                            <span>{{ \App\Helpers\TranslationHelper::translate('About Us') }}
                            </span>
                            <h2><span
                                    style="color: rgb(241, 196, 15);">{{ \App\Helpers\TranslationHelper::translate('Our Story and Goals') }}
                                </span></h2>
                            <p> {!! $about->description_story !!}
                            </p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="img-hero" data-aos="fade-up" data-aos-duration="1000">
                            <img src="{{ $about->getFirstMediaUrl('abouts_image') }}" alt=""
                                class="animated-image">
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="section-one pt-2">
            <div class="container ">
                <div class="row align-items-center ">
                    <div class="col-md-6 pt-3">
                        <div class="text-hero-2 text-center" data-aos="fade-up" data-aos-duration="1000">
                            <img src="{{ asset('front/assets/img/roaetna.svg') }}" alt="">
                            <h2><span style="color: rgb(241, 196, 15);">
                                    {{ \App\Helpers\TranslationHelper::translate('Our Vision') }}
                                </span></h2>
                            <p> {!! $about->description_see_us !!}
                            </p>
                        </div>
                    </div>
                    <div class="col-md-6 pt-3">
                        <div class="text-hero-2 text-center" data-aos="fade-up" data-aos-duration="1000">
                            <img src="{{ asset('front/assets/img/mohmetnie.svg') }}" alt="">
                            <h2><span
                                    style="color: rgb(241, 196, 15);">{{ \App\Helpers\TranslationHelper::translate('Our Mission') }}
                                </span></h2>
                            <p>
                                {!! $about->description_our_mission !!}
                            </p>
                        </div>
                    </div>

                </div>
            </div>
        </section>

        <section class="section-one pt-2">
            <div class="container ">
                <div class="row align-items-center ">
                    <div class="col-md-12 pt-3">
                        <div class="text-hero-3" data-aos="fade-up" data-aos-duration="1000"
                            style="color: rgb(241, 196, 15);">

                            {!! setting('description_home', app()->getLocale()) !!}
                            {{-- <p style="text-align: right;">
                                <span style="color: rgb(255, 255, 255);">
                                    {!! setting('description_home', app()->getLocale()) !!}
                                   </span>
                                   </p> --}}
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="section-one pt-5">
            <div class="container ">
                <div class="row align-items-center ">
                    <div class="col-md-6" data-aos="fade-up" data-aos-duration="1000">
                        <div class="text-hero-4">
                            <h2><span style="color: rgb(241, 196, 15);">

                                    {{ \App\Helpers\TranslationHelper::translate('Overview of the Initial Coin Plan and Our Business Plan') }}
                                </span></h2>
                            <p>
                                <span style="color: rgb(255, 255, 255);">
                                    {!! $about->description_about_the_plan !!}
                                </span>
                            </p>

                            <a href="{{ route('blogs') }}" class="btn-main-vido">
                                <button style="background-color: rgb(255 255 255 / 20%);
    color: #ffffff;"
                                    class="btn btn-main-top text-center">{{ \App\Helpers\TranslationHelper::translate('For more videos and news') }}</button>
                            </a>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="img-hero-2" data-aos="fade-up" data-aos-duration="1000">
                            <img src="{{ $about->getFirstMediaUrl('abouts_meta_image') }}" alt=""
                                class="animated-image">
                        </div>
                    </div>

                </div>
            </div>
        </section>

        <section id="section-one" class="section-one pt-2">
            <div class="container ">
                <div class="row align-items-center">
                    <div class="col-md-12 pt-3">
                        <div class="text-hero-5" data-aos="fade-up" data-aos-duration="1000">
                            <h2><span style="color: rgb(241, 196, 15);">
                                    {{ \App\Helpers\TranslationHelper::translate('Royal Crown Vip Cards') }}
                                </span></h2>
                            <div class="btn-moer d-flex gap-4 justify-content-center pt-2">
                                <a
                                    href="{{ route('regular-card') }}">{{ \App\Helpers\TranslationHelper::translate('Show More') }}</a>
                                <a
                                    href="{{ route('contact-us') }}">{{ \App\Helpers\TranslationHelper::translate('Contact Us') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>



        <section class="card-one">
            <div class="container">

                {{-- <div class="row pt-5">
                @foreach ($regular_cards as $regular_card)
                    <div class="col-md-3">
                        <div class="product-card" data-aos="fade-up" data-aos-duration="1000">
                            <img src="{{ $regular_card->getFirstMediaUrl('cards') }}" alt="Product Image 1">
            <h3>{{ $regular_card->categorycolid->name }}</h3>
            <h3 class="subtitle more-info-toggle" style="cursor: pointer; color: #fff;">
                {{ \App\Helpers\TranslationHelper::translate('Click to learn more') }}
            </h3>
            <div class="product-details" style="display: none; background: #470d14; color: #fff; padding: 10px; border-radius: 10px; margin-top: 10px;">
                <div style="max-height: 150px; overflow-y: auto; padding-right: 10px;">
                    {!! strip_tags($regular_card->des) !!}
                </div>
                <div class="d-flex justify-content-between mt-3">
                    <a href="{{ route('show-card', ['id' => $regular_card->id]) }}" class="custom-button btn-custom">
                        {{ \App\Helpers\TranslationHelper::translate('Details') }}
                    </a>
                    <a href="{{ route('order-card', ['id' => $regular_card->id]) }}" class="custom-button btn-custom">
                        {{ \App\Helpers\TranslationHelper::translate('Shop') }}
                        <i class="fas fa-cart-plus"></i>
                    </a>
                </div>
            </div>
        </div>
        </div>
        @endforeach
        </div> --}}

                <div class="row">
                    @foreach ($regular_cards as $regular_card)
                        <div class="col-md-3">
                            <div class="product-card" data-aos="fade-up" data-aos-duration="1000" style=" width: 100%;">
                                <img src="{{ $regular_card->getFirstMediaUrl('cards') }}" alt="Product Image 1">
                                <h3>{{ $regular_card->categorycolid->name }}</h3>
                                <h3 class="subtitle"> <a href="{{ route('regular-card') }}">
                                        {{ \App\Helpers\TranslationHelper::translate('More') }}
                                    </a></h3>
                            </div>
                        </div>
                    @endforeach

                </div>
            </div>
        </section>



        <section class="section-one pt-2">
            <div class="container ">
                <div class="row align-items-center ">
                    <div class="col-md-12 pt-3">
                        <div class="text-hero-5" data-aos="fade-up" data-aos-duration="1000">
                            <h2><span style="color: rgb(241, 196, 15);">
                                    {{ \App\Helpers\TranslationHelper::translate('Royal Crown Vip Cards') }}
                                </span></h2>
                            <span
                                style="color: #fff;">{{ \App\Helpers\TranslationHelper::translate('Royal Cards Section') }}
                            </span>
                            <div class="btn-moer d-flex gap-4 justify-content-center pt-2">
                                <a
                                    href="{{ route('royal-card') }}">{{ \App\Helpers\TranslationHelper::translate('Show More') }}</a>
                                <a
                                    href="{{ route('contact-us') }}">{{ \App\Helpers\TranslationHelper::translate('Contact Us') }}</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>

        <section class="card-one">
            <div class="container">
                <div class="row">

                    @foreach ($royal_cards as $royal_card)
                        <div class="col-md-4">
                            <div class="product-card" data-aos="fade-up" data-aos-duration="1000" style=" width: 100%;">
                                <img src="{{ $royal_card->getFirstMediaUrl('cards') }}" alt="Product Image 1">
                                <h3>{{ $royal_card->categorycolid->name }}</h3>
                                <h3 class="subtitle"> <a href="{{ route('royal-card') }}">
                                        {{ \App\Helpers\TranslationHelper::translate('More') }}
                                    </a></h3>
                            </div>
                        </div>
                    @endforeach

                </div>
            </div>
        </section>


        <section class="section-one pt-2">
            <div class="container ">
                <div class="row align-items-center ">
                    <div class="col-md-12 pt-3">
                        <div class="text-hero-5" data-aos="fade-up" data-aos-duration="1000">
                            <h2><span style="color: rgb(241, 196, 15);">
                                    {{ \App\Helpers\TranslationHelper::translate('Royal Crown Vip Cards') }}
                                </span></h2>
                            <span
                                style="color: #fff;">{{ \App\Helpers\TranslationHelper::translate('Imperial Cards Section') }}
                            </span>
                            <div class="btn-moer d-flex gap-4 justify-content-center pt-2">
                                <a
                                    href="{{ route('imperial-card') }}">{{ \App\Helpers\TranslationHelper::translate('Show More') }}</a>
                                <a
                                    href="{{ route('contact-us') }}">{{ \App\Helpers\TranslationHelper::translate('Contact Us') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>



        <section class="card-one">
            <div class="container">
                <div class="row">
                    @foreach ($imperial_cards as $imperial_card)
                        <div class="col-md-4">
                            <div class="product-card" data-aos="fade-up" data-aos-duration="1000" style=" width: 100%;">
                                <img src="{{ $imperial_card->getFirstMediaUrl('cards') }}" alt="Product Image 1">
                                <h3>{{ $imperial_card->categorycolid->name }}</h3>
                                <h3 class="subtitle"> <a href="{{ route('imperial-card') }}">
                                        {{ \App\Helpers\TranslationHelper::translate('More') }}
                                    </a></h3>
                            </div>
                        </div>
                    @endforeach


                </div>
            </div>
        </section>
        <button id="scrollButton" onclick="scrollToTop()">⬆</button>
    </main>
@endsection


@push('js')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <script></script>
@endpush
