@extends('front.layouts.app')

@section('content')
    @if (!$project->is_active)
        <div class="overlay" id="overlay">
            <div class="container h-100">
                <div class="row align-items-center justify-content-center h-100">
                    <div class="col-md-4 text-center text-md-start">
                        <p class="coming-soon">
                            {{ \App\Helpers\TranslationHelper::translate('This content will be available soon') }}
                        </p>
                    </div>
                    <div class="col-md-4 text-center">
                        <button class="lock-btn" onclick="unlockContent()">
                            <img src="{{ asset('front/assets/img/lock.png') }}" alt="" class="img-fluid">
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif


    <section class="hero-section py-5" style="background: linear-gradient(to right, #a42249, #6d1330);">
        <div class="container">
            <div class="row justify-content-center align-items-center text-center g-4">
                <div class="col-md-3 d-flex flex-column align-items-center align-self-start">
                    <img src="{{ $project->getFirstMediaUrl('projects_image') }}" class="img-fluid rounded"
                        alt="{{ $project->name }}" style="max-width: 140px; height: auto;">
                    <div class="d-flex justify-content-center mt-3">
                        <button class="download-btn mx-2">
                            <img src="{{ asset('front/assets/img/android.jpg') }}" alt="Download for Android">
                        </button>
                        <button class="download-btn mx-2">
                            <img src="{{ asset('front/assets/img/ios.jpg') }}" alt="Download for iPhone">
                        </button>
                    </div>
                </div>
                <div class="col-md-6 text-center">
                    <h2 class="fw-bold text-white" data-aos="zoom-in">{{ $project->name }}</h2>
                    <div class="description-box p-4 rounded shadow-lg"
                        style="background: rgba(255, 255, 255, 0.2); line-height: 1.8em; max-width: 100%; margin: auto;">
                        <p class="text-white">{!! $project->description !!}</p>
                    </div>
                </div>
                <div class="col-md-3 d-flex justify-content-center align-self-start mt-n3">
                    <img src="{{ asset(setting('image_logo', 'en')) }}" class="img-fluid rounded" alt="Logo"
                        style="max-width: 150px; height: auto;">
                </div>
            </div>
        </div>
    </section>

    @php
    $langKey = app()->getLocale();
@endphp

<section class="video-section py-5" style="background: linear-gradient(to right, #a42249, #6d1330);">
    <div class="container" style="max-width: 960px; margin: auto;">
        <div class="row justify-content-center">

            <div class="col-md-6 d-flex justify-content-center">
                <div class="card shadow-lg border-0" style="width: 90%;">
                    <div class="ratio ratio-16x9">
                        @php
                            $video1 = $project->getFirstMediaUrl("projectsprojectsproject_video_{$langKey}");
                        @endphp
                        @if($video1)
                            <video controls style="width: 100%; height: 250px; object-fit: cover;">
                                <source src="{{ $video1 }}" type="video/mp4">
                            </video>
                        @else
                            <p class="text-white text-center">{{ \App\Helpers\TranslationHelper::translate('No video available') }}</p>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-md-6 d-flex justify-content-center">
                <div class="card shadow-lg border-0" style="width: 90%;">
                    <div class="ratio ratio-16x9">
                        @php
                            $video2 = $project->getFirstMediaUrl("projectsprojectsproject_video_tow_{$langKey}");
                        @endphp

                        @if($video2)
                            <video controls style="width: 100%; height: 250px; object-fit: cover;">
                                <source src="{{ $video2 }}" type="video/mp4">
                            </video>
                        @else
                            <p class="text-white text-center">{{ \App\Helpers\TranslationHelper::translate('No video available') }}</p>
                        @endif
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>



@endsection


@push('js')
    {{-- <script>
        function unlockContent() {
            let overlay = document.getElementById("overlay");
            overlay.style.opacity = "0";

            setTimeout(() => {
                overlay.style.display = "none";
                document.getElementById("main-content").style.display = "block";
            }, 300);
        }
    </script> --}}
@endpush
