@extends('front.layouts.app')


@section('content')


    <div
        class="tr-breadcurmb-area tr-breadcurmb-bg mb-30"
        style="background-image: url({{(setting('image_panarea_tow', 'en'))}}); background-size: cover; background-position: center; height: 200px;"
    >
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8">
                    <div class="tr-breadcurmb-content text-center z-index-3">
                        <div class="tr-breadcurmb-title-box">
                            <h3 class="tr-breadcurmb-title">{{ \App\Helpers\TranslationHelper::translate('My Profile') }}</h3>
                        </div>
                        <div class="tr-breadcurmb-list-wrap">
                            <div class="tr-breadcurmb-list">
                                <span><a href="{{route('site.home')}}">{{ \App\Helpers\TranslationHelper::translate('Home') }}</a></span>
                                <span class="dvdr"
                                ><i class="fa-regular fa-angle-right"></i
                                    ></span>
                                <i>{{ \App\Helpers\TranslationHelper::translate('My Profile') }}</i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <section class="small-section" style="margin-bottom: 100px">
        <div class="container">
            <div class="row">
                @include('front.includes.side_menu')
                <div class="col">
                    <div class="dashboard_common_table">
                        <h3>{{\App\Helpers\TranslationHelper::translate('My Profile')}}</h3>
                        <div class="profile_update_form">
                            <form action="{{route('user.updateProfile')}}" method="POST" id="profile_form_area">
                                @csrf

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label
                                                for="f-name">{{\App\Helpers\TranslationHelper::translate('First name')}}</label>
                                            <input type="text" class="form-control" id="f-name" name="name"
                                                   placeholder="{{\App\Helpers\TranslationHelper::translate('Your Name')}}"
                                                   value="{{auth()->user()->name}}">
                                            @error('name')
                                            <span class="text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label
                                                for="l-name">{{\App\Helpers\TranslationHelper::translate('Last name')}}</label>
                                            <input type="text" class="form-control" id="l-name" name="l_name"
                                                   value="{{auth()->user()->l_name}}">
                                            @error('l_name')
                                            <span class="text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label
                                                for="mail-address">{{\App\Helpers\TranslationHelper::translate('Email address')}}</label>
                                            <input type="text" class="form-control" id="mail-address" name="email"
                                                   value="{{auth()->user()->email}}">
                                            @error('email')
                                            <span class="text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label
                                                for="mobil-number">{{\App\Helpers\TranslationHelper::translate('Mobile number')}}</label>
                                            <input type="text" class="form-control" name="phone" id="mobil-number"
                                                   value="{{auth()->user()->phone}}">
                                            @error('phone')
                                            <span class="text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label
                                                for="u-name">{{\App\Helpers\TranslationHelper::translate('User name')}}</label>
                                            <input type="text" class="form-control" id="u-name" name="username"
                                                   value="{{auth()->user()->username}}">
                                            @error('username')
                                            <span class="text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>


                                <div class="tr-cta-btn">
                                    <button type="submit" class="btn tr-btn" style="background: #fff!important;">
                                        {{\App\Helpers\TranslationHelper::translate('Update Profile')}}
                                    </button>
                                </div>
                            </form>
                            {{-- <form action="{{route('user.dashboard.password.change')}}" method="post" id="profile_form_area" class="mt-5"> --}}
                            <form action="{{route('user.changePassword')}}" method="post" id="profile_form_area"
                                  class="mt-5">
                                @csrf
                                <div class="row">


                                    <div class="change_password_input_boxed">
                                        <h3>{{ \App\Helpers\TranslationHelper::translate('Change password') }}</h3>
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <input type="password" class="form-control" name="old_password"
                                                           placeholder="{{\App\Helpers\TranslationHelper::translate('Old Password')}}">
                                                    @error('old_password')
                                                    <span class="text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                    @enderror
                                                </div>

                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <input type="password" class="form-control" name="new_password"
                                                           placeholder="{{\App\Helpers\TranslationHelper::translate('New Password')}}">
                                                    @error('new_password')
                                                    <span class="text-danger" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                    @enderror
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tr-cta-btn">
                                    <button type="submit" class="btn tr-btn" style="background: #fff!important;">
                                        {{\App\Helpers\TranslationHelper::translate('Change Password')}}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="tr-subscribe-area z-index-2">
        <div class="container">
            <div class="tr-subscribe-bg p-relative fix">
                <div class="tr-subscribe-img d-none d-lg-block">
                    <img src="{{ (setting('Subscribe_image', 'en'))}}" alt=""/>
                </div>
                <div class="tr-subscribe-circle d-none d-lg-block">
                    <span></span>
                </div>
                <div class="row">
                    <div class="offset-xl-5 offset-lg-5 col-xl-7 col-lg-7">
                        <div class="tr-subscribe-tittle-box mb-35">
                            <h3 class="tr-section-title mb-20 text-white">
                                <br/>
                                {{ setting('section_five_title_one', app()->getLocale()) }}
                            </h3>
                            <p>
                                {!! setting('section_five_description_one', app()->getLocale()) !!}
                            </p>
                        </div>
                        <div class="tr-subscribe-form">
                            <form action="#">
                                <div class="tr-subscribe-input p-relative">
                                    <input type="text" placeholder="{{ \App\Helpers\TranslationHelper::translate('Your email...') }}"/>
                                    <button
                                        class="tr-subscribe-button tr-btn-green light-green"
                                        type="submit"
                                    >
                                        {{ \App\Helpers\TranslationHelper::translate('Subscribe ') }}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
